/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.playersplus.forge;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.fuzzycraft.core.asm.ClientHookManager;
import net.fuzzycraft.playersplus.forge.PlayersPlusBaseProxy;
import net.fuzzycraft.playersplus.forge.PlayersPlusKeyHandler;
import net.fuzzycraft.playersplus.forge.PlayersPlusModelPieces;
import net.fuzzycraft.playersplus.manager.PlayerFeature;
import net.fuzzycraft.playersplus.manager.PlayerFeatureRegistry;
import net.fuzzycraft.playersplus.manager.PlayerPartsRegistry;
import net.fuzzycraft.playersplus.rendering.PlayerImageBufferDownload;
import net.fuzzycraft.playersplus.rendering.RenderPlayerPieces;
import net.fuzzycraft.playersplus.rendering.RenderPlayerPlus;
import net.fuzzycraft.playersplus.rendering.RenderPlayerProxy;
import net.fuzzycraft.playersplus.ui.GuiScreenAvatar;

@SideOnly(value=Side.CLIENT)
public class PlayersPlusClientProxy
extends PlayersPlusBaseProxy
implements ClientHookManager.OnPreEntityCreateListener,
ClientHookManager.OnPreEntityDestroyListener,
ClientHookManager.OnPlayerLoadFileListener {
    private Set<String> mPreloadedSkins = new HashSet<String>();
    private RenderPlayerProxy mRootPlayerModel;

    @Override
    public void onPacketData(cl manager, dz packet, Player player) {
        if (packet.a.equals("FC|PPF")) {
            bij engine = ats.w().N;
            LinkedList<String> oldImages = new LinkedList<String>();
            LinkedList<String> newImages = new LinkedList<String>();
            String username = PlayerFeatureRegistry.getInstance().getPacketUsername(packet);
            PlayerFeature feature = PlayerFeatureRegistry.getPlayerFeatures(username);
            if (feature.replacementSkinURL != null) {
                oldImages.add(feature.replacementSkinURL);
            }
            PlayerFeatureRegistry.getInstance().readPacket(packet);
            feature = PlayerFeatureRegistry.getPlayerFeatures(username);
            if (feature.replacementSkinURL != null) {
                newImages.add(feature.replacementSkinURL);
            }
        } else {
            super.onPacketData(manager, packet, player);
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mRootPlayerModel = new RenderPlayerProxy();
        this.detectPwnHostileMods();
        RenderingRegistry.registerEntityRenderingHandler(ue.class, (bgj)this.mRootPlayerModel);
        PlayerPartsRegistry.getInstance().mDefaultPlayer = new RenderPlayerPlus();
        PlayerPartsRegistry.getInstance().mRenders.put("piecemodel", new RenderPlayerPieces());
        PlayerPartsRegistry.getInstance().mRandomParts.addAll(Arrays.asList("torso", "head", "arm_l", "arm_r", "leg_l", "leg_r"));
        bij engine = ats.w().N;
        List<PlayerFeature> features = PlayerFeatureRegistry.getInstance().allActiveFeatures();
        for (PlayerFeature feature : features) {
        }
        ClientHookManager nonFmlHooks = ClientHookManager.getInstance();
        nonFmlHooks.addOnPreEntityCreateListener((ClientHookManager.OnPreEntityCreateListener)this);
        nonFmlHooks.addOnPreEntityDestroyListener((ClientHookManager.OnPreEntityDestroyListener)this);
        nonFmlHooks.addOnPlayerLoadFileListener((ClientHookManager.OnPlayerLoadFileListener)this);
        this.debugModelState();
        PlayersPlusModelPieces.registerPieces();
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new PlayersPlusKeyHandler());
    }

    @Override
    public void onRequestAvatarScreen() {
        ats.w().a((awb)new GuiScreenAvatar());
    }

    public void onPreEntityCreate(bfi renderGlobal, nm entity) {
    }

    public void onPreEntityDestroy(bfi renderGlobal, nm entity) {
    }

    public void onPlayerLoadFile(bjl par0ResourceLocation, String par1Str, bjl par2ResourceLocation, bff par3IImageBuffer) {
        bij texturemanager = ats.w().J();
        bil object = texturemanager.b(par0ResourceLocation);
        if (object == null) {
            if (par3IImageBuffer != null) {
                par3IImageBuffer = new PlayerImageBufferDownload();
            }
            object = new bhz(par1Str, par2ResourceLocation, par3IImageBuffer);
            texturemanager.a(par0ResourceLocation, object);
        }
    }

    private void detectPwnHostileMods() {
        Collection<bhg> currentRenders = PlayerPartsRegistry.getInstance().mRenders.values();
        HashSet indexedRenders = new HashSet();
        for (bhg render : currentRenders) {
            indexedRenders.add(render.getClass());
        }
        indexedRenders.add(bhg.class);
        indexedRenders.add(RenderPlayerProxy.class);
        HashSet currentSet = new HashSet(bgi.a.q.keySet());
        for (Class entityClass : currentSet) {
            if (!ue.class.isAssignableFrom(entityClass)) continue;
            bgj render = (bgj)bgi.a.q.get(entityClass);
            if (render instanceof bhg) {
                bhg realrender = (bhg)render;
                if (!indexedRenders.contains(realrender.getClass())) {
                    indexedRenders.add(realrender.getClass());
                    String key = "slave." + realrender.getClass().getCanonicalName();
                    PlayerPartsRegistry.getInstance().mRenders.put(key, realrender);
                    PlayerFeatureRegistry.getInstance().appendEnum("renderer", new String[]{key});
                }
                if (!realrender.getClass().equals(bhg.class) && !realrender.getClass().equals(RenderPlayerProxy.class)) {
                    FMLRelaunchLog.warning((String)("PlayersPlus detected a conflicting mod overriding the player. Enslaving " + render.getClass().getCanonicalName() + " guarding " + entityClass.getCanonicalName()), (Object[])new Object[0]);
                }
                bgi.a.q.put(entityClass, this.mRootPlayerModel);
                continue;
            }
            FMLRelaunchLog.severe((String)("PlayersPlus detected a non-player renderer for a player object. Getting rid of " + render.getClass().getCanonicalName() + " guarding " + entityClass.getCanonicalName()), (Object[])new Object[0]);
            bgi.a.q.put(entityClass, this.mRootPlayerModel);
        }
    }

    private void debugModelState() {
        for (Object entry : bgi.a.q.keySet()) {
            Class entityClass = (Class)entry;
            if (!ue.class.isAssignableFrom(entityClass)) continue;
            System.out.println("Renderer for " + entityClass.getCanonicalName() + " extends EntityPlayer: " + bgi.a.q.get(entityClass).getClass().getCanonicalName());
        }
    }

    @Override
    public void onServerStarted(FMLServerStartedEvent event) {
        this.debugModelState();
        this.detectPwnHostileMods();
    }
}

