/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.playersplus.manager;

import java.util.HashMap;
import java.util.Map;

public class PlayerFeature {
    public EarFeature mEars;
    public String replacementSkinURL = null;
    public String replacementSkinFile = null;
    public Map<String, String> mPublicSettings = new HashMap<String, String>();
    public Map<String, Object> mClientSettings = new HashMap<String, Object>();

    public PlayerFeature() {
        this.setTestFeatures();
    }

    public PlayerFeature(String content) {
        String[] kvs;
        this.setTestFeatures();
        for (String kv : kvs = content.split("\\|")) {
            String[] separation = kv.split("=", 2);
            if (separation.length == 1) {
                this.mPublicSettings.put(separation[0], "");
                continue;
            }
            if (separation.length != 2) continue;
            this.mPublicSettings.put(separation[0], separation[1]);
        }
    }

    public String getStorageString() {
        String components = "";
        for (Map.Entry<String, String> entry : this.mPublicSettings.entrySet()) {
            if (components.length() > 0) {
                components = components + "|";
            }
            components = components + entry.getKey() + "=" + entry.getValue();
        }
        return components;
    }

    private void setTestFeatures() {
        this.mPublicSettings.put("renderer", "piecemodel");
        this.mPublicSettings.put("skinfile", "playersplus:skins/rin.png");
    }

    public PlayerFeature duplicate() {
        PlayerFeature copy = new PlayerFeature();
        for (String key : this.mPublicSettings.keySet()) {
            copy.mPublicSettings.put(key, this.mPublicSettings.get(key));
        }
        return copy;
    }

    public static enum EarFeature {
        EARS_NONE,
        EARS_MOUSE_S,
        EARS_MOUSE_L,
        EARS_ELEPHANT,
        EARS_DOG,
        EARS_CAT;

    }
}

