/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.playersplus.manager;

import com.google.common.io.LineReader;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fuzzycraft.playersplus.manager.PlayerFeature;

public class PlayerFeatureRegistry {
    PlayerFeature mDefaultFeature = new PlayerFeature();
    protected Map<String, PlayerFeature> mServerFeatures;
    protected Map<String, PlayerFeature> mClientFeatures;
    protected Map<String, String[]> mEnumFeatures;
    private static PlayerFeatureRegistry mInstance = new PlayerFeatureRegistry();
    public static final String CHANNEL_FEATURE = "FC|PPF";
    public static final String CHANNEL_REQUEST = "FC|PPS";

    public static PlayerFeature getPlayerFeatures(String player) {
        PlayerFeature features = PlayerFeatureRegistry.mInstance.mClientFeatures.get(player);
        if (features == null) {
            features = PlayerFeatureRegistry.mInstance.mDefaultFeature.duplicate();
            PlayerFeatureRegistry.mInstance.mClientFeatures.put(player, features);
        }
        return features;
    }

    public static PlayerFeature getServerPlayerFeatures(String player) {
        PlayerFeature features = PlayerFeatureRegistry.mInstance.mServerFeatures.get(player);
        if (features == null) {
            features = PlayerFeatureRegistry.mInstance.mDefaultFeature.duplicate();
        }
        return features;
    }

    private PlayerFeatureRegistry() {
        this.mDefaultFeature.mEars = PlayerFeature.EarFeature.EARS_DOG;
        this.mServerFeatures = new HashMap<String, PlayerFeature>();
        this.mClientFeatures = new HashMap<String, PlayerFeature>();
        this.mEnumFeatures = new HashMap<String, String[]>();
        this.loadFeaturesFromFile();
    }

    public static PlayerFeatureRegistry getInstance() {
        return mInstance;
    }

    public void setLocalFeatureForPlayer(String player, PlayerFeature feature) {
        this.mClientFeatures.put(player, feature);
    }

    public void setGlobalFeatureForPlayer(String player, PlayerFeature feature) {
        this.mServerFeatures.put(player, feature);
    }

    public void loadFeaturesFromFile() {
        File input = new File("fuzzycraft.skins");
        if (!input.exists()) {
            FMLRelaunchLog.info((String)"no fuzzycraft.skins file has been created yet", (Object[])new Object[0]);
            return;
        }
        try {
            String line;
            FileReader filereader = new FileReader(input);
            LineReader reader = new LineReader((Readable)filereader);
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(":", 2);
                if (parts.length == 2) {
                    PlayerFeature feature = new PlayerFeature(parts[1]);
                    this.mServerFeatures.put(parts[0], feature);
                    continue;
                }
                if (line.equals("")) continue;
                FMLRelaunchLog.severe((String)"Syntax error in the skinfile: '%s'", (Object[])new Object[]{line});
            }
            filereader.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void storeFeatures() {
        FMLRelaunchLog.info((String)"Storing fuzzycraft.skins", (Object[])new Object[0]);
        File output = new File("fuzzycraft.skins");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            for (String key : this.mServerFeatures.keySet()) {
                writer.write(key + ":" + this.mServerFeatures.get(key).getStorageString());
                writer.newLine();
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String feature(String username) {
        return username + ":" + PlayerFeatureRegistry.getPlayerFeatures(username).getStorageString();
    }

    public String feature(String username, PlayerFeature settings) {
        return username + ":" + settings.getStorageString();
    }

    public dz getFeatureCommand(String player) {
        return new dz(CHANNEL_FEATURE, this.feature(player, PlayerFeatureRegistry.getServerPlayerFeatures(player)).getBytes(Charset.forName("UTF-8")));
    }

    public static dz getFeatureRequest(String username, PlayerFeature feature) {
        String request = username + ":" + feature.getStorageString();
        return new dz(CHANNEL_REQUEST, request.getBytes(Charset.forName("UTF-8")));
    }

    public void readPacket(dz packet) {
        String text = new String(packet.c, Charset.forName("UTF-8"));
        String[] components = text.split(":", 2);
        if (components.length != 2) {
            return;
        }
        PlayerFeature feature = new PlayerFeature(components[1]);
        this.mClientFeatures.put(components[0], feature);
    }

    public static PlayerFeature featureFromPacket(dz packet) {
        String text = new String(packet.c, Charset.forName("UTF-8"));
        String[] components = text.split(":", 2);
        if (components.length < 2) {
            return null;
        }
        String compose = components[1];
        for (int i = 2; i < components.length; ++i) {
            compose = compose + ":" + components[i];
        }
        PlayerFeature feature = new PlayerFeature(compose);
        return feature;
    }

    public String getPacketUsername(dz packet) {
        String text = new String(packet.c, Charset.forName("UTF-8"));
        String[] components = text.split(":");
        if (components.length < 2) {
            return "";
        }
        return components[0];
    }

    public void broadcastFeatureChange(String player, hm server) {
        List clients = server.a;
        for (ju client : clients) {
            client.a.b((ex)this.getFeatureCommand(player));
        }
    }

    public void sendFeaturesForLogin(String newplayer, hm server) {
        List clients = server.a;
        ju loggedinclient = server.f(newplayer);
        Set<String> keyset = this.mServerFeatures.keySet();
        for (ju client : clients) {
            if (keyset.contains(client.bu)) {
                loggedinclient.a.b((ex)this.getFeatureCommand(client.bu));
            }
            if (!keyset.contains(loggedinclient.bu)) continue;
            client.a.b((ex)this.getFeatureCommand(loggedinclient.bu));
        }
    }

    public List<PlayerFeature> allActiveFeatures() {
        LinkedList<PlayerFeature> features = new LinkedList<PlayerFeature>();
        features.addAll(this.mClientFeatures.values());
        features.add(this.mDefaultFeature);
        return features;
    }

    public void registerEnum(String featurename, String[] options) {
        this.mEnumFeatures.put(featurename, options);
    }

    public void appendEnum(String featurename, String[] options) {
        if (this.mEnumFeatures.containsKey(featurename)) {
            String[] existingOptions = this.mEnumFeatures.get(featurename);
            String[] newOptions = new String[options.length + existingOptions.length];
            System.arraycopy(existingOptions, 0, newOptions, 0, existingOptions.length);
            System.arraycopy(options, 0, newOptions, existingOptions.length, options.length);
            this.registerEnum(featurename, newOptions);
        } else {
            this.registerEnum(featurename, options);
        }
    }

    public Collection<String> getEnums() {
        return this.mEnumFeatures.keySet();
    }

    public List<String> getEnumOptions(String key) {
        if (!this.mEnumFeatures.containsKey(key)) {
            return new ArrayList<String>();
        }
        String[] values = this.mEnumFeatures.get(key);
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values) {
            list.add(value);
        }
        return list;
    }
}

