/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.playersplus.ui;

import java.util.ArrayList;
import java.util.List;
import net.fuzzycraft.playersplus.manager.PlayerFeature;
import net.fuzzycraft.playersplus.manager.PlayerFeatureRegistry;
import net.fuzzycraft.playersplus.ui.GuiEnumSlider;

public class PlayerFeatureAdapter
implements GuiEnumSlider.IDataSource,
GuiEnumSlider.IEnumSliderListener {
    private String mKey;
    private String mUser;

    public PlayerFeatureAdapter(String featurekey, String username) {
        this.mKey = featurekey;
        this.mUser = username;
    }

    private List<String> getFeatureList() {
        return new ArrayList<String>(PlayerFeatureRegistry.getInstance().getEnumOptions(this.mKey));
    }

    @Override
    public int getItemCount() {
        return this.getFeatureList().size();
    }

    @Override
    public String getNameForItem(int index) {
        List<String> values = this.getFeatureList();
        bu stringtranslate = bu.a();
        if (index >= values.size()) {
            return stringtranslate.a("gui.playersplus.invalidenum");
        }
        String value = values.get(index);
        return stringtranslate.a("gui.playersplus.featurekey." + this.mKey) + ": " + stringtranslate.a("gui.playersplus.featurevalue." + this.mKey + "." + value);
    }

    @Override
    public void onUpdateSlider(GuiEnumSlider slider, int option) {
        List<String> values = this.getFeatureList();
        if (option >= values.size()) {
            return;
        }
        bdf player = ats.w().h;
        PlayerFeature feature = PlayerFeatureRegistry.getPlayerFeatures(player.bu);
        feature.mPublicSettings.put(this.mKey, values.get(option));
        player.a.c((ex)PlayerFeatureRegistry.getFeatureRequest(player.bu, feature));
    }

    public int getCurrent() {
        PlayerFeature feature = PlayerFeatureRegistry.getPlayerFeatures(this.mUser);
        String value = feature.mPublicSettings.get(this.mKey);
        if (value == null) {
            return 0;
        }
        List<String> values = this.getFeatureList();
        if (!values.contains(value)) {
            return 0;
        }
        return values.indexOf(value);
    }
}

